<?php

namespace XF\Option;

use XF\Entity\Option;

class GoogleAnalytics extends AbstractOption
{
	public static function verifyWebPropertyOption(&$wpId, Option $option)
	{
		if ($wpId !== '' && !preg_match('/^(UA-\d+-\d+|G-[a-zA-Z0-9]+)$/', $wpId))
		{
			$option->error(\XF::phrase('please_enter_your_google_analytics_web_property_id_in_format'), $option->option_id);
			return false;
		}

		return true;
	}
}
