<?php
/**
 * @brief		4.7.1 Beta 1 Upgrade Code
 * @author		<a href='https://www.invisioncommunity.com'>Invision Power Services, Inc.</a>
 * @copyright	(c) Invision Power Services, Inc.
 * @license		https://www.invisioncommunity.com/legal/standards/
 * @package		Invision Community
 * @subpackage	Downloads
 * @since		11 Jul 2022
 */

namespace IPS\downloads\setup\upg_107018;

/* To prevent PHP errors (extending class does not exist) revealing path */

use IPS\Db;
use function defined;

if ( !defined( '\IPS\SUITE_UNIQUE_KEY' ) )
{
	header( ( $_SERVER['SERVER_PROTOCOL'] ?? 'HTTP/1.0' ) . ' 403 Forbidden' );
	exit;
}

/**
 * 4.7.1 Beta 1 Upgrade Code
 */
class Upgrade
{
	/**
	 * Update published value
	 *
	 * @return	bool|array 	If returns TRUE, upgrader will proceed to next step. If it returns any other value, it will set this as the value of the 'extra' GET parameter and rerun this step (useful for loops)
	 */
	public function step1() : array|bool
	{
		Db::i()->query( "UPDATE " . Db::i()->prefix . "downloads_files SET file_published=file_updated WHERE file_published=0" );

		return TRUE;
	}
	
	// You can create as many additional methods (step2, step3, etc.) as is necessary.
	// Each step will be executed in a new HTTP request
}